package.path = "./app/lib/?.lua;" .. package.path
require("ucs2")

local LESS = require("app.core.lession")
local Y = require("app.core.page")

-- Tests
local function test_short()

	local span_count = 5

	local page = Y.new_page(LESS.load("./app/test/short"), span_count)
	
	---
	assert(page ~= nil)
	
	---
	assert(page:push_back(L"ASDF") == true)
	assert(page:locate() == 2)
	assert(L"ASDF" == page.less:se(1))

end

local function test_ten()

	local span_count = 5

	local page = Y.new_page(LESS.load("./app/test/ten"), span_count)
	
	---
	assert(page ~= nil)
	
	---
	assert(page:se(1) == L"1")

	---
	assert(page:push_back(L"1") == true)
	assert(page:locate() == 2)
	assert(L"1" == page.less:se(1))
	
	---
	page:push_back(L"2")
	page:push_back(L"3")
	page:push_back(L"4")
	page:push_back(L"5")
	
	---
	assert(page:se(1) == L"6")
	assert(page:locate() == 6)
	
	---
	page:pop_back()
	assert(page:se(1) == L"1")
	assert(page:locate() == 5)

	---
	page:pop_back()
	page:pop_back()
	page:pop_back()
	page:pop_back()
	page:pop_back()
	page:pop_back()
	page:pop_back()
	page:pop_back()
	assert(page:locate() == 1)
	assert(page:se(1) == L"1")
	assert(page:se(2) == L"2")
	assert(page:se(3) == L"3")
	assert(page:se(4) == L"4")
	assert(page:se(5) == L"5")

	assert(page:se(10000) == L"")
	
end

local function test_long()
	
	local span_count = 5
	local page = Y.new_page(LESS.load("./app/test/ATaleofTwoCities"), span_count)
	
	assert(page ~= nil)
	
	local s = L"01234567890123456789012345678901"
	page:push_back(s)
	assert(page:locate() == 2)
	
	assert(page:si(1) == s)
	assert(page:stat(1) == L"dddddddddddddddddddddddddddddddd")
	local yml = yaml.load(page:update())
	assert(yml.span1.freeze == true)
	assert(yml.span2.freeze == false)
	assert(yml.span3.freeze == true)
	assert(yml.span4.freeze == true)
	assert(yml.span5.freeze == true)

end


-- Run Tests
print(pcall(test_short))
print(pcall(test_ten))
print(pcall(test_long))
